﻿using System;
using System.Collections.Generic;
using System.Web.UI.WebControls;

public partial class SurveyLink : BasePage
{
    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/Survey.aspx",
        "/Surveys.aspx.",
        "/Survey2009.aspx",
        "/Survey2012.aspx",
        "/PatientWorkflows.aspx"
    };

    public SurveyLink()
    {
        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            int surveyId;
            if (Request.QueryString["activityId"] != null)
            {
                if (int.TryParse(Request.QueryString["activityId"], out surveyId))
                {
                    string formVersion = "Unknown";      
                    try
                    {
                        formVersion = SqlProvider.ExecuteScalar(
                            "RegistryConnectionString", "dbo.GetEFRFormVersion",
                            new object[] { surveyId }).ToString(); 
                    }
                    catch (Exception exc)
                    { 
                        Logging.WriteLogToFile("Error processing new referral", exc); 
                    }

                    FormVersion.Text = "The current version of this form is: " + formVersion;
                }

                hl2009.NavigateUrl = "Survey2009.aspx?activityId=" + surveyId;
                hl2012.NavigateUrl = "Survey2012.aspx?activityId=" + surveyId;
            }

            SetReferringPage();
        }
    }

    protected void Surveys_RowDataBound(object sender, GridViewRowEventArgs e)
    {

    }

    protected void CancelButton_OnClick(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "New";
    }

    public override string AppObjectCode()
    {
        return "EFR QUESTIONNAIRES";
    }
}









